IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Seg_User_Fav') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Seg_User_Fav 
END
GO

CREATE PROCEDURE CPJ_Seg_User_Fav		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pAccion				CHAR(1),  --A=ADD    C=CHANGE     D=DELETE
		@pId_Usuario			SMALLINT,
		@pId_Modulo				SMALLINT,
		@pId_Menu				SMALLINT,
		@pOrden					SMALLINT,
		@pFlag_Grupo			TINYINT,
		@pDescripcion			VARCHAR(250),
		@pId_Favorito_Padre		INT,
		@pId_Favorito			INT


SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pAccion				= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJson,'Accion')), '')
SET @pId_Usuario			= CONVERT(SMALLINT,dbo.CF_JSON_VALUE(@pJson,'Id_Usuario'))
SET @pId_Modulo				= CONVERT(SMALLINT,dbo.CF_JSON_VALUE(@pJson,'Id_Modulo'))
SET @pId_Menu				= CONVERT(SMALLINT,dbo.CF_JSON_VALUE(@pJson,'Id_Menu'))
SET	@pOrden					= CONVERT(SMALLINT,dbo.CF_JSON_VALUE(@pJson,'Orden'))
SET	@pFlag_Grupo			= CONVERT(TINYINT,dbo.CF_JSON_VALUE(@pJson,'Flag_Grupo'))
SET	@pDescripcion			= CONVERT(VARCHAR(250),dbo.CF_JSON_VALUE(@pJson,'Descripcion'))
SET @pId_Favorito_Padre		= CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Favorito_Padre'))
SET @pId_Favorito			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Favorito')),0)


BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Seg_User_Fav'
		PRINT 'Parmetros: '+ @pJson  
	END
	/*===================================================================*/	

	IF UPPER(@pAccion) NOT IN ('A','C','D') RAISERROR ('Parameter "Accion" must be A C D (ADD,CHANGE,DELETE)', 16,  1 )

	IF UPPER(@pAccion) = 'A'
	BEGIN
		INSERT INTO Seg_User_Fav (Id_Usuario,Id_Modulo,Id_Menu,Orden,Flag_Grupo,Descripcion,Id_Favorito_Padre)
			VALUES (@pId_Usuario,@pId_Modulo,@pId_Menu,@pOrden,@pFlag_Grupo,@pDescripcion,@pId_Favorito_Padre)
	END

	IF UPPER(@pAccion) = 'C'
	BEGIN
		IF @pId_Favorito = 0 RAISERROR ('Parameter "Id_Favorito" can not be 0', 16,  1 )
		UPDATE Seg_User_Fav SET Orden =  @pOrden , Flag_Grupo = @pFlag_Grupo , Descripcion = @pDescripcion, Id_Usuario = @pId_Usuario, Id_Modulo = @pId_Modulo, Id_Menu = @pId_Menu 
			WHERE  Id_Favorito = @pId_Favorito
			
	END

 	IF UPPER(@pAccion) = 'D'
	BEGIN
		IF @pId_Favorito = 0 RAISERROR ('Parameter "Id_Favorito" can not be 0', 16,  1 )
		DELETE Seg_User_Fav WHERE Id_Favorito = @pId_Favorito
	END




	/*===================================================================*/	

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,''				AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Seg_User_Fav'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 
